﻿using System;

namespace UsingFinallyBlock
{
    class Tester
    {
        public void Run()
        {
            try
            {
                Console.WriteLine("Tu otwórz plik");
                double a = 5;
                double b = 0;
                Console.WriteLine("{0} / {1} = {2}", a, b, DoDivide(a, b));
                Console.WriteLine("Ta linijka może zostać wydrukowana albo i nie");
            }
            // najpierw najbardziej charakterystyczny wyjątek
            catch (DivideByZeroException)
            {
                Console.WriteLine("Przechwycono wyjątek DivideByZeroException!");
            }
            catch
            {
                Console.WriteLine("Przechwycono nieznany wyjątek");
            }
            finally
            {
                Console.WriteLine("Tu zamknij plik");
            }
        }
        // wykonaj dzielenie, jeśli jest dopuszczalne
        public double DoDivide(double a, double b)
        {
            if (b == 0)
                throw new DivideByZeroException();
            if (a == 0)
                throw new ArithmeticException();
            return a / b;
        }

        static void Main()
        {
            Console.WriteLine("Wejście w Main()...");
            Tester t = new Tester();
            t.Run();
            Console.WriteLine("Wyjście z Main()...");
        }
    }
}